/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.block.display.AllDisplayBehaviours;
import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.block.display.DisplayLinkConfigurationPacket;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.DisplayLinkTileEntity;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.source.SingleLineDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ModularGuiLine;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.ui.PonderTagScreen;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DisplayLinkScreen
extends AbstractSimiScreen {
    private static final ItemStack FALLBACK = new ItemStack((ItemLike)Items.f_42127_);
    private AllGuiTextures background = AllGuiTextures.DATA_GATHERER;
    private DisplayLinkTileEntity te;
    private IconButton confirmButton;
    BlockState sourceState;
    BlockState targetState;
    List<DisplaySource> sources;
    DisplayTarget target;
    ScrollInput sourceTypeSelector;
    Label sourceTypeLabel;
    ScrollInput targetLineSelector;
    Label targetLineLabel;
    AbstractSimiWidget sourceWidget;
    AbstractSimiWidget targetWidget;
    Couple<ModularGuiLine> configWidgets;

    public DisplayLinkScreen(DisplayLinkTileEntity te) {
        this.te = te;
        this.sources = Collections.emptyList();
        this.configWidgets = Couple.create(ModularGuiLine::new);
        this.target = null;
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        super.m_7856_();
        this.m_169413_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.initGathererOptions();
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::m_7379_);
        this.m_142416_(this.confirmButton);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        if (this.sourceState != null && this.sourceState.m_60734_() != this.f_96541_.f_91073_.m_8055_(this.te.getSourcePosition()).m_60734_() || this.targetState != null && this.targetState.m_60734_() != this.f_96541_.f_91073_.m_8055_(this.te.getTargetPosition()).m_60734_()) {
            this.initGathererOptions();
        }
    }

    private void initGathererOptions() {
        ClientLevel level = this.f_96541_.f_91073_;
        this.sourceState = level.m_8055_(this.te.getSourcePosition());
        this.targetState = level.m_8055_(this.te.getTargetPosition());
        int x = this.guiLeft;
        int y = this.guiTop;
        Block sourceBlock = this.sourceState.m_60734_();
        Block targetBlock = this.targetState.m_60734_();
        ItemStack asItem = sourceBlock.m_7397_((BlockGetter)level, this.te.getSourcePosition(), this.sourceState);
        ItemStack sourceIcon = asItem == null || asItem.m_41619_() ? FALLBACK : asItem;
        asItem = targetBlock.m_7397_((BlockGetter)level, this.te.getTargetPosition(), this.targetState);
        ItemStack targetIcon = asItem == null || asItem.m_41619_() ? FALLBACK : asItem;
        this.sources = AllDisplayBehaviours.sourcesOf((LevelAccessor)level, this.te.getSourcePosition());
        this.target = AllDisplayBehaviours.targetOf((LevelAccessor)level, this.te.getTargetPosition());
        this.m_169411_(this.targetLineSelector);
        this.m_169411_(this.targetLineLabel);
        this.m_169411_(this.sourceTypeSelector);
        this.m_169411_(this.sourceTypeLabel);
        this.m_169411_(this.sourceWidget);
        this.m_169411_(this.targetWidget);
        this.configWidgets.forEach(s -> s.forEach(this::m_169411_));
        this.targetLineSelector = null;
        this.sourceTypeSelector = null;
        if (this.target != null) {
            DisplayTargetStats stats = this.target.provideStats(new DisplayLinkContext((Level)level, this.te));
            int rows = stats.maxRows();
            int startIndex = Math.min(this.te.targetLine, rows);
            this.targetLineLabel = new Label(x + 65, y + 109, Components.immutableEmpty()).withShadow();
            this.targetLineLabel.text = this.target.getLineOptionText(startIndex);
            if (rows > 1) {
                this.targetLineSelector = new ScrollInput(x + 61, y + 105, 135, 16).withRange(0, rows).titled(Lang.translateDirect("display_link.display_on", new Object[0])).inverted().calling(i -> {
                    this.targetLineLabel.text = this.target.getLineOptionText((int)i);
                }).setState(startIndex);
                this.m_142416_(this.targetLineSelector);
            }
            this.m_142416_(this.targetLineLabel);
        }
        this.sourceWidget = ((AbstractSimiWidget)new ElementWidget(x + 37, y + 26).showingElement(GuiGameElement.of(sourceIcon))).withCallback((mX, mY) -> ScreenOpener.open(new PonderTagScreen(PonderTag.DISPLAY_SOURCES)));
        this.sourceWidget.getToolTip().addAll(List.of(Lang.translateDirect("display_link.reading_from", new Object[0]), this.sourceState.m_60734_().m_49954_().m_130938_(s -> s.m_178520_(this.sources.isEmpty() ? 16157065 : 15909229)), Lang.translateDirect("display_link.attached_side", new Object[0]), Lang.translateDirect("display_link.view_compatible", new Object[0]).m_130940_(ChatFormatting.GRAY)));
        this.m_142416_(this.sourceWidget);
        this.targetWidget = ((AbstractSimiWidget)new ElementWidget(x + 37, y + 105).showingElement(GuiGameElement.of(targetIcon))).withCallback((mX, mY) -> ScreenOpener.open(new PonderTagScreen(PonderTag.DISPLAY_TARGETS)));
        this.targetWidget.getToolTip().addAll(List.of(Lang.translateDirect("display_link.writing_to", new Object[0]), this.targetState.m_60734_().m_49954_().m_130938_(s -> s.m_178520_(this.target == null ? 16157065 : 15909229)), Lang.translateDirect("display_link.targeted_location", new Object[0]), Lang.translateDirect("display_link.view_compatible", new Object[0]).m_130940_(ChatFormatting.GRAY)));
        this.m_142416_(this.targetWidget);
        if (!this.sources.isEmpty()) {
            int startIndex = Math.max(this.sources.indexOf(this.te.activeSource), 0);
            this.sourceTypeLabel = new Label(x + 65, y + 30, Components.immutableEmpty()).withShadow();
            this.sourceTypeLabel.text = this.sources.get(startIndex).getName();
            if (this.sources.size() > 1) {
                List<Component> options = this.sources.stream().map(DisplaySource::getName).toList();
                this.sourceTypeSelector = new SelectionScrollInput(x + 61, y + 26, 135, 16).forOptions(options).writingTo(this.sourceTypeLabel).titled(Lang.translateDirect("display_link.information_type", new Object[0])).calling(this::initGathererSourceSubOptions).setState(startIndex);
                this.sourceTypeSelector.onChanged();
                this.m_142416_(this.sourceTypeSelector);
            } else {
                this.initGathererSourceSubOptions(0);
            }
            this.m_142416_(this.sourceTypeLabel);
        }
    }

    private void initGathererSourceSubOptions(int i) {
        DisplaySource source = this.sources.get(i);
        source.populateData(new DisplayLinkContext(this.te.m_58904_(), this.te));
        if (this.targetLineSelector != null) {
            this.targetLineSelector.titled(source instanceof SingleLineDisplaySource ? Lang.translateDirect("display_link.display_on", new Object[0]) : Lang.translateDirect("display_link.display_on_multiline", new Object[0]));
        }
        this.configWidgets.forEach(s -> {
            s.forEach(this::m_169411_);
            s.clear();
        });
        DisplayLinkContext context = new DisplayLinkContext((Level)this.f_96541_.f_91073_, this.te);
        this.configWidgets.forEachWithContext((s, first) -> source.initConfigurationWidgets(context, new ModularGuiLineBuilder(this.f_96547_, (ModularGuiLine)s, this.guiLeft + 60, this.guiTop + (first != false ? 51 : 72)), (boolean)first));
        this.configWidgets.forEach(s -> s.loadValues(this.te.getSourceConfig(), x$0 -> {
            NarratableEntry cfr_ignored_0 = (NarratableEntry)this.m_142416_((GuiEventListener)x$0);
        }, x$0 -> {
            NarratableEntry cfr_ignored_0 = (NarratableEntry)this.m_169394_((Widget)x$0);
        }));
    }

    public void m_7379_() {
        super.m_7379_();
        CompoundTag sourceData = new CompoundTag();
        if (!this.sources.isEmpty()) {
            sourceData.m_128359_("Id", this.sources.get((int)(this.sourceTypeSelector == null ? 0 : this.sourceTypeSelector.getState())).id.toString());
            this.configWidgets.forEach(s -> s.saveValues(sourceData));
        }
        AllPackets.channel.sendToServer((Object)new DisplayLinkConfigurationPacket(this.te.m_58899_(), sourceData, this.targetLineSelector == null ? 0 : this.targetLineSelector.getState()));
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(ms, x, y, (GuiComponent)this);
        MutableComponent header = Lang.translateDirect("display_link.title", new Object[0]);
        this.f_96547_.m_92889_(ms, (Component)header, (float)(x + this.background.width / 2 - this.f_96547_.m_92852_((FormattedText)header) / 2), (float)(y + 4), 0x442000);
        if (this.sources.isEmpty()) {
            this.f_96547_.m_92763_(ms, (Component)Lang.translateDirect("display_link.no_source", new Object[0]), (float)(x + 65), (float)(y + 30), 0xD3D3D3);
        }
        if (this.target == null) {
            this.f_96547_.m_92763_(ms, (Component)Lang.translateDirect("display_link.no_target", new Object[0]), (float)(x + 65), (float)(y + 109), 0xD3D3D3);
        }
        ms.m_85836_();
        ms.m_85837_(0.0, (double)(this.guiTop + 46), 0.0);
        ((ModularGuiLine)this.configWidgets.getFirst()).renderWidgetBG(this.guiLeft, ms);
        ms.m_85837_(0.0, 21.0, 0.0);
        ((ModularGuiLine)this.configWidgets.getSecond()).renderWidgetBG(this.guiLeft, ms);
        ms.m_85849_();
        ms.m_85836_();
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).pushPose()).translate((double)(x + this.background.width + 4), (double)(y + this.background.height + 4), 100.0)).scale(40.0f)).rotateX(-22.0)).rotateY(63.0);
        GuiGameElement.of((BlockState)this.te.m_58900_().m_61124_((Property)DisplayLinkBlock.f_52588_, (Comparable)Direction.UP)).render(ms);
        ms.m_85849_();
    }

    protected void m_169411_(GuiEventListener p_169412_) {
        if (p_169412_ != null) {
            super.m_169411_(p_169412_);
        }
    }
}

